<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// 사용자 중요 정보: 데이터베이스 연결 설정
define('DB_HOST', 'localhost');
define('DB_USERNAME', 'veliziasystem_hangang');
define('DB_PASSWORD', 'Osito.1852570');
define('DB_NAME', 'veliziasystem_corea');

class Db {
    protected $dbh;
    public function __construct(){ 
        try {
            date_default_timezone_set("America/Caracas");
            $this->dbh = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME, DB_USERNAME, DB_PASSWORD,
                [PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"] );
            $this->dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch(PDOException $e) { die("연결 오류: " . $e->getMessage()); }
    }
    public function DBConsulta($sql) {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

// 날짜 처리 및 새 필터
$fecha_inicio = $_GET['desde'] ?? date('Y-m-d');
$fecha_fin    = $_GET['hasta'] ?? date('Y-m-d');
$filtro_mesero = $_GET['mesero'] ?? ''; 
$filtro_ticket = $_GET['ticket'] ?? ''; 
$filtro_pago    = $_GET['pago'] ?? '';   

$tra = new Db();

// 환율 가져오기
$res_tasa = $tra->DBConsulta("SELECT montocambio FROM tiposcambio ORDER BY codcambio DESC LIMIT 1");
$tasa_dia = $res_tasa[0]['montocambio'] ?? 1;


// 일반적인 결제 방식에 대한 번역 매핑 (DB 데이터와 일치해야 합니다, 대문자)
$traducciones_pago = [
    'EFECTIVO' => '현금',          // Efectivo
    'TRANSFERENCIA' => '계좌이체',   // Transferencia
    'PUNTO' => '카드 단말기',      // Punto de Venta
    'ZELLE' => 'Zelle',             // Zelle
    'PAGO MOVIL' => '모바일 결제',     // Pago Móvil
    // 데이터베이스의 다른 결제 방식을 정확하게 대문자로 추가하세요:
    // 'OTRO' => '기타',
];


// --- 모든 기존 결제 방식 가져오기 (필터 선택용) ---
$pagos_sql = "SELECT DISTINCT formapago FROM ventas WHERE formapago IS NOT NULL AND formapago != ''
              UNION 
              SELECT DISTINCT formapago2 AS formapago FROM ventas WHERE formapago2 IS NOT NULL AND formapago2 != ''";
$tipos_pago = $tra->DBConsulta($pagos_sql);

// --- 필터를 포함한 SQL 쿼리 준비 ---
$where_clauses = ["DATE(V.fechaventa) BETWEEN '$fecha_inicio' AND '$fecha_fin'"];

// 1. 종업원 필터 (부분 일치)
if (!empty($filtro_mesero)) {
    $where_clauses[] = "U.nombres LIKE '%" . $filtro_mesero . "%'";
}

// 2. 티켓 번호 필터 (codfactura 또는 codventa 부분 일치)
if (!empty($filtro_ticket)) {
    $where_clauses[] = "(V.codfactura LIKE '%" . $filtro_ticket . "%' OR V.codventa LIKE '%" . $filtro_ticket . "%')";
}

// 3. 결제 방식 필터 (복합 결제 포함)
if (!empty($filtro_pago)) {
    // 특수 경우: 복합 결제
    if ($filtro_pago === 'Mixto') {
        // formapago2가 사용되었고 금액이 양수인 경우, 복합 결제입니다.
        $where_clauses[] = "V.formapago2 IS NOT NULL AND V.formapago2 != '' AND V.montopagado2 > 0";
    } else {
        // 결제 방식이 결제 1 또는 결제 2에 있는지 확인합니다.
        $where_clauses[] = "(V.formapago = '" . $filtro_pago . "' OR V.formapago2 = '" . $filtro_pago . "')";
    }
}

// 모든 WHERE 조건 결합
$where_string = "WHERE " . implode(" AND ", $where_clauses);

// 최종 판매 쿼리
$sql = "SELECT V.*, S.nomsala, U.nombres as mesero_nombre
        FROM ventas V 
        LEFT JOIN mesas M ON V.codmesa = M.codmesa 
        LEFT JOIN salas S ON M.codsala = S.codsala 
        LEFT JOIN usuarios U ON V.codigo = U.codigo 
        $where_string
        ORDER BY V.fechaventa DESC";

$ventas = $tra->DBConsulta($sql);
$totales_globales = ['subtotal' => 0, 'iva' => 0, 'propina' => 0, 'total' => 0];
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>한강 - 판매 및 부가가치세 관리 (Hangang - Control de Ventas e IVA)</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* 한국어 글꼴 지원 추가 */
        body { font-size: 11px; background: #f4f6f9; color: #333; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif, 'Malgun Gothic', 'Dotum'; }
        .main-card { background: white; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.08); padding: 25px; }
        .table-header { background: #1a1a1a; color: #fff; text-transform: uppercase; letter-spacing: 1px; }
        .monto-usd { color: #0d6efd; font-weight: 700; display: block; font-size: 1.1em; }
        .monto-bs { color: #dc3545; font-size: 0.9em; display: block; font-style: italic; }
        .total-row { background-color: #fff9db !important; }
        .footer-final { background: #1a1a1a; color: #fff; font-size: 1.2em; }
        .filter-box { background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 8px; padding: 15px; margin-bottom: 20px; }
        .badge-mesero { background: #e7f1ff; color: #0056b3; padding: 4px 8px; border-radius: 4px; font-weight: 600; }
        
        .badge-pago { font-size: 0.85em; margin-bottom: 2px; display: inline-block; width: 100%; }
        
        .btn-print-ticket { 
            float: right; 
            background: #ffc107; 
            color: #000; 
            border: none; 
            padding: 5px 10px; 
            border-radius: 5px;
            transition: 0.2s;
        }
        .btn-print-ticket:hover { background: #e0a800; transform: scale(1.1); }

        @media print { .filter-box, .btn-print, .btn-print-ticket { display: none; } }
    </style>
</head>
<body class="p-4">

<div class="container-fluid main-card">
    <div class="row align-items-center mb-4">
        <div class="col-md-6">
            <h3 class="m-0 fw-bold text-dark">한강 (HANGANG)</h3>
            <p class="text-muted mb-0">판매, 부가가치세 (16%) 및 팁 마스터 관리</p>
            <span class="badge bg-secondary">기간: <?=$fecha_inicio?> 부터 <?=$fecha_fin?></span>
        </div>
        <div class="col-md-6 text-end">
            <div class="d-inline-block text-center p-2 border rounded bg-light">
                <small class="text-uppercase fw-bold d-block text-muted">오늘의 환율</small>
                <strong class="fs-5 text-danger">Bs. <?=number_format($tasa_dia, 2, ',', '.')?></strong>
            </div>
            <button onclick="window.print()" class="btn btn-dark btn-sm ms-2 btn-print">전체 보고서 인쇄</button>
        </div>
    </div>

    <div class="filter-box">
        <form method="GET" class="row g-3 align-items-end mb-3">
            <div class="col-md-2">
                <label class="form-label fw-bold small">부터 (Desde):</label>
                <input type="date" name="desde" class="form-control form-control-sm" value="<?=$fecha_inicio?>">
            </div>
            <div class="col-md-2">
                <label class="form-label fw-bold small">까지 (Hasta):</label>
                <input type="date" name="hasta" class="form-control form-control-sm" value="<?=$fecha_fin?>">
            </div>
            
            <div class="col-md-2">
                <label class="form-label fw-bold small">종업원 (Mesero):</label>
                <input type="text" name="mesero" class="form-control form-control-sm" value="<?=$filtro_mesero?>" placeholder="종업원 이름">
            </div>
            
            <div class="col-md-2">
                <label class="form-label fw-bold small">티켓/영수증 (Ticket/Factura):</label>
                <input type="text" name="ticket" class="form-control form-control-sm" value="<?=$filtro_ticket?>" placeholder="티켓/영수증 ID">
            </div>

            <div class="col-md-2">
                <label class="form-label fw-bold small">결제 방식 (Forma de Pago):</label>
                <select name="pago" class="form-select form-select-sm">
                    <option value="">— 전체 —</option>
                    
                    <option value="Mixto" <?php if($filtro_pago === 'Mixto') echo 'selected'; ?>>
                        복합 결제
                    </option>
                    
                    <?php foreach(array_unique(array_column($tipos_pago, 'formapago')) as $pago): 
                        if (empty($pago)) continue; 
                        
                        $pago_upper = strtoupper(htmlentities($pago));
                        
                        // Determinar la etiqueta a mostrar con traducción si existe
                        $traduccion = $traducciones_pago[$pago_upper] ?? ''; 
                        $etiqueta_final = ($traduccion) ? $traduccion . " ({$pago_upper})" : $pago_upper;
                    ?>
                    <option value="<?=htmlentities($pago)?>" <?php if($filtro_pago === $pago) echo 'selected'; ?>>
                        <?=$etiqueta_final?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary btn-sm w-100">필터 적용</button>
            </div>
        </form>
    </div>

    <table class="table table-bordered align-middle" id="tablaVentas">
        <thead class="table-header text-center small">
            <tr>
                <th width="18%">식별 정보</th>
                <th width="18%">결제 상세</th>
                <th>소계 (순액)</th>
                <th>부가가치세 (16%)</th>
                <th>팁</th>
                <th>총 지불 금액</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($ventas as $v): 
                // 정확한 총액 계산 (Calculamos los totales EXACTAMENTE como lo hace el reporte)
                $v_sub = (float)($v['subtotalivasi'] + $v['subtotalivano']);
                $v_iva = $v_sub * 0.16;
                $v_pro = (float)$v['montopropina'];
                $v_tot = $v_sub + $v_iva + $v_pro;

                $totales_globales['subtotal'] += $v_sub;
                $totales_globales['iva']      += $v_iva;
                $totales_globales['propina']  += $v_pro;
                $totales_globales['total']    += $v_tot;
            ?>
            <tr class="venta-row">
                <td class="searchable-ticket">
                    <a href="ticket_pdf.php?codventa=<?=$v['codventa']?>" target="_blank" class="btn-print-ticket" title="티켓 인쇄">
                        <i class="fas fa-print"></i>
                    </a>
                    <div class="fw-bold text-dark">티켓 번호: <?=$v['codfactura']?></div>
                    <div class="small text-muted">내부 ID: <?=$v['codventa']?></div>
                    <div class="small text-muted">주문: <?=$v['codpedido']?></div>
                    <div class="mt-1"><span class="badge-mesero"><?=strtoupper($v['mesero_nombre'])?></span></div>
                </td>
                
                <td class="searchable-pago">
                    <?php 
                    // Pago 1
                    $formapago1_upper = strtoupper($v['formapago'] ?? '');
                    $pago1_traduccion = $traducciones_pago[$formapago1_upper] ?? $formapago1_upper;
                    ?>
                    <?php if(!empty($v['formapago']) && $v['montopagado'] > 0): ?>
                    <div class="mb-2 border-bottom pb-1">
                        <span class="badge bg-primary badge-pago"><?=$pago1_traduccion?> (<?=$formapago1_upper?>)</span>
                        <div class="fw-bold text-end">$<?=number_format($v['montopagado'], 2)?></div>
                    </div>
                    <?php endif; ?>
                    
                    <?php 
                    // Pago 2 (Mixto)
                    $formapago2_upper = strtoupper($v['formapago2'] ?? '');
                    $pago2_traduccion = $traducciones_pago[$formapago2_upper] ?? $formapago2_upper;
                    ?>
                    <?php if(!empty($v['formapago2']) && $v['montopagado2'] > 0): ?>
                    <div>
                        <span class="badge bg-info text-dark badge-pago"><?=$pago2_traduccion?> (<?=$formapago2_upper?>) (복합)</span>
                        <div class="fw-bold text-end">$<?=number_format($v['montopagado2'], 2)?></div>
                    </div>
                    <?php endif; ?>
                </td>

                <td class="text-end">
                    <span class="monto-usd">$ <?=number_format($v_sub, 2)?></span>
                    <span class="monto-bs">Bs. <?=number_format($v_sub * $tasa_dia, 2, ',', '.')?></span>
                </td>
                <td class="text-end">
                    <span class="monto-usd">$ <?=number_format($v_iva, 2)?></span>
                    <span class="monto-bs">Bs. <?=number_format($v_iva * $tasa_dia, 2, ',', '.')?></span>
                </td>
                <td class="text-end">
                    <span class="monto-usd">$ <?=number_format($v_pro, 2)?></span>
                    <span class="monto-bs">Bs. <?=number_format($v_pro * $tasa_dia, 2, ',', '.')?></span>
                </td>
                <td class="text-end total-row">
                    <span class="monto-usd">$ <?=number_format($v_tot, 2)?></span>
                    <span class="monto-bs fw-bold">Bs. <?=number_format($v_tot * $tasa_dia, 2, ',', '.')?></span>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot class="footer-final text-end">
            <tr>
                <td colspan="2" class="text-center fw-bold">총계</td>
                <td>$ <?=number_format($totales_globales['subtotal'], 2)?><br><small>Bs. <?=number_format($totales_globales['subtotal'] * $tasa_dia, 2, ',', '.')?></small></td>
                <td>$ <?=number_format($totales_globales['iva'], 2)?><br><small>Bs. <?=number_format($totales_globales['iva'] * $tasa_dia, 2, ',', '.')?></small></td>
                <td>$ <?=number_format($totales_globales['propina'], 2)?><br><small>Bs. <?=number_format($totales_globales['propina'] * $tasa_dia, 2, ',', '.')?></small></td>
                <td class="bg-warning text-dark fw-bold">$ <?=number_format($totales_globales['total'], 2)?><br><span>Bs. <?=number_format($totales_globales['total'] * $tasa_dia, 2, ',', '.')?></span></td>
            </tr>
        </tfoot>
    </table>
</div>

</body>
</html>