  function TicketPrecuenta()
{
$imp = new Login();
$imp = $imp->ImpuestosPorId();
$impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
$valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

$tra = new Login();
$reg = $tra->DetallesPedido();
$simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

    // INCLUSIÓN DE LA LÓGICA DE TASA DE CAMBIO DEL TICKET DE VENTA
    $tipoCambio = $tra->ObtenerTipoCambio();
    $valorCambio = ($tipoCambio ? $tipoCambio['montocambio'] : 1.00);
    $simboloCambio = ($tipoCambio ? $tipoCambio['descripcioncambio'] : 'Bs.'); 

if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
$logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
$this->Image($logo , 14, 4, 50, 12, "PNG");
$this->Ln(6);
}

$this->SetX(4);
$this->SetFont('Courier','B',12);
$this->SetFillColor(2,157,116);
$this->Cell(66, 5, "TICKET DE PRECUENTA", 0, 0, 'C');
$this->Ln(5);

$this->SetX(4);
$this->SetFont('Courier','B',10);
$this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

if($reg[0]['tipopedido'] == 1){
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(16,3,"SALA:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(50,3,utf8_decode($reg[0]['nomsala']),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(16,3,"Nº MESA:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(50,3,portales(utf8_decode($reg[0]['nommesa'])),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(12,3,"MESERO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(54,3,utf8_decode($reg[0]['nombre_mesero']),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');
} else {
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(12,3,"CAJERO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(54,3,utf8_decode($reg[0]['nombres']),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
}

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->SetTextColor(3, 3, 3);
$this->SetFillColor(229, 229, 229);
$this->Cell(4,3,'Nº',0,0,'C');
$this->Cell(62,3,'DETALLES',0,1,'C');

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

$this->SetWidths(array(4,62));

$cantidad = 0;
$SubTotal = 0;
$a=1;
for($i=0;$i<sizeof($reg);$i++){
$SubTotal += $reg[$i]['suma'];

$this->SetX(4);
$this->SetDrawColor(255, 255, 255);
$this->SetLineWidth(.1);
$detalles = str_replace("<br>","\n", $reg[$i]['detalles']);
$this->SetFont('Courier','B',7.8);
$this->SetTextColor(3,3,3);
$this->Row(array(utf8_decode($a++),portales(utf8_decode($detalles))));

// Mostrar el subtotal del producto en Dólares y Bolívares
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->Cell(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[$i]['suma'], 2, '.', ',')),0,1,'R');
$this->Ln(0.5); // Salto de linea

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->Cell(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[$i]['suma']*$valorCambio, 2, '.', ',')),0,1,'R');
$this->Ln(0.5);
}

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);


    // #############################################
    // # CÁLCULOS COHERENTES CON EL TICKET DE VENTA #
    // #############################################
    
    // Total del pedido (SubTotal - Descuento + Impuestos)
    $total_base_dolares = $reg[0]["totalpago"];

    // Servicio 10%
    $servicio_dolares = $total_base_dolares * 0.10;
    $servicio_bs = $servicio_dolares * $valorCambio;

    // IMPORTE TOTAL FINAL (Base + Servicio, SE QUITA EL DELIVERY)
    $importe_total_final_dolares = $total_base_dolares + $servicio_dolares;
    $importe_total_final_bs = $importe_total_final_dolares * $valorCambio;


// #############################################
    // # IMPRESIÓN DE TOTALES #
    // #############################################

// SUBTOTAL EN DÓLARES
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($SubTotal, 2, '.', ',')),0,1,'R');

// SUBTOTAL EN BOLÍVARES
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($SubTotal*$valorCambio, 2, '.', ',')),0,1,'R');

// DESCUENTO EN DÓLARES
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DESC % (".number_format($reg[0]["descuento"], 2, '.', ',')."%):",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totaldescuento"], 2, '.', ',')),0,1,'R');

// DESCUENTO EN BOLÍVARES
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DESC % (".number_format($reg[0]["descuento"], 2, '.', ',')."%):",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["totaldescuento"]*$valorCambio, 2, '.', ',')),0,1,'R');

    // # SERVICIO #
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SERVICIO 10%:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($servicio_dolares, 2, '.', ',')),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SERVICIO 10%:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($servicio_bs, 2, '.', ',')),0,1,'R');


    // # IMPORTE TOTAL (FINAL) #
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($importe_total_final_dolares, 2, '.', ',')),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($importe_total_final_bs, 2, '.', ',')),0,1,'R');
    
    // # TOTAL A CANCELAR: Mantiene el mismo valor que el Importe Total #
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"TOTAL A CANCELAR:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($importe_total_final_dolares, 2, '.', ',')),0,1,'R');
$this->Ln(1);

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"TOTAL A CANCELAR:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($importe_total_final_bs, 2, '.', ',')),0,1,'R');
$this->Ln(1);


$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,0.5,'--------------------------',0,1,'C');
$this->SetX(2);
$this->Cell(70,0.5,'--------------------------',0,1,'C');
$this->Ln(3);

$this->SetX(4);
$this->SetFont('Courier','BI',9);
$this->SetFillColor(3, 3, 3);
$this->CellFitSpace(66,3,"GRACIAS POR PREFERIRNOS",0,1,'C');
$this->CellFitSpace(66,3,"Control Interno",0,1,'C');
$this->Ln(3);
}