function TicketVenta()
{
// Instancia de Login para obtener datos de impuestos
$imp = new Login();
$imp_data = $imp->ImpuestosPorId();
$impuesto = ($imp_data == "" ? "IMPUESTO" : $imp_data[0]['nomimpuesto']);
$valor = ($imp_data == "" ? "0.00" : $imp_data[0]['valorimpuesto']); // Esto parece ser el valor porcentual del impuesto por ID

$tra = new Login(); // Usamos esta instancia para otras consultas

// **Líneas de ObtenerImpuestoActivo() ELIMINADAS**
    
$reg = $tra->VentasPorId();
    
// Nueva línea para obtener el tipo de cambio
$tipoCambio = $tra->ObtenerTipoCambio();
$valorCambio = ($tipoCambio ? $tipoCambio['montocambio'] : 1.00);
// Debería verse así
$simboloCambio = ($tipoCambio ? $tipoCambio['descripcioncambio'] : 'Bs.');
    
$simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
//$logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
//$this->Image($logo , 14, 4, 50, 12, "PNG");
//$this->Ln(6);
}
    
$this->SetX(4);
$this->SetFont('Courier','B',12);
$this->SetFillColor(2,157,116);
$this->Cell(66, 5, "TICKET DE VENTA", 0, 0, 'C');
$this->Ln(5);
    
$this->SetX(4);
$this->SetFont('Courier','B',10);
$this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(66,3,$reg[0]['documsucursal'] == '0' ? "" : "Nº ".$reg[0]['documento']." ".utf8_decode($reg[0]['cuitsucursal']),0,1,'C');

if($reg[0]['id_provincia']!='0'){
$this->SetX(4);
$this->CellFitSpace(66,3,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia'])." ".$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento'])),0,1,'C');
}

$this->SetX(4);
$this->CellFitSpace(66,3,utf8_decode($reg[0]['direcsucursal']),0,1,'C');

if($reg[0]['codgiro'] != "0"){
$this->SetX(4);
$this->CellFitSpace(66,3,"N° ACTIVIDAD/GIRO: ".utf8_decode($reg[0]['codgiro']),0,1,'C');
}
    
if($reg[0]['fechaautorsucursal'] != "0000-00-00"){
$this->SetX(4);
$this->CellFitSpace(66,3,"DE:".utf8_decode($reg[0]['fechaautorsucursal']),0,1,'C');
}
    
if($reg[0]['girosucursal'] != "0"){
$this->SetX(4);
$this->CellFitSpace(66,3,utf8_decode($reg[0]['girosucursal']),0,1,'C');
}

$this->SetX(4);
$this->CellFitSpace(66,3,"OBLIGADO A LLEVAR CONTABILIDAD: ".utf8_decode($reg[0]['llevacontabilidad']),0,1,'C');
    
$this->SetX(4);
$this->CellFitSpace(66,3,"AMBIENTE: PRODUCCIÓN",0,1,'C');
    
$this->SetX(4);
$this->CellFitSpace(66,3,"EMISIÓN: NORMAL",0,1,'C');
    
$this->SetX(4);
$this->CellFitSpace(66,3,"CLAVE DE ACCESO - N° DE AUTORIZACIÓN",0,1,'C');
    
$this->SetX(4);
$this->CellFitSpace(66,3,utf8_decode($reg[0]['codautorizacion']),0,1,'C');

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

$this->SetX(4);
$this->SetFont('Courier','B',10);
$this->CellFitSpace(20,3,"Nº TICKET:",0,0,'L');
$this->SetFont('Courier','B',13);
$this->CellFitSpace(46,3,utf8_decode($reg[0]['codfactura']),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(16,3,"CAJA Nº:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(50,3,utf8_decode($reg[0]['nrocaja']."-".$reg[0]['nomcaja']),0,1,'L');
    
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(16,3,"CAJERO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(50,3,utf8_decode($reg[0]['nombres']),0,1,'L');

if($reg[0]['delivery']=="1"){
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
}

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"FECHA VENTA:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,date("d-m-Y H:i:s",strtotime($reg[0]['fechaventa'])),0,1,'L');

if($reg[0]['tipoventa'] == 2){
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"FECHA ENTREGA:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,date("d-m-Y",strtotime($reg[0]['fechaentrega'])),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"HORA ENTREGA:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,date("H:i:s",strtotime($reg[0]['fechaentrega'])),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"STATUS PEDIDO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,$reg[0]['statuspedido'] == 1 ? "PENDIENTE" : "ENTREGADO",0,1,'L');
}
    
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,date("d-m-Y H:i:s"),0,1,'L');

$this->SetFont('Courier','B',12);
$this->SetX(2);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

if($reg[0]['nomcliente']==""){
$this->SetFont('Courier','B',8);
$this->SetX(4);
$this->CellFitSpace(66, 3, "CONSUMIDOR FINAL",0,1,'C');
} else {
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(15,3,$documento = ($reg[0]['documcliente'] == '0' ? "Nº DOC:" : "Nº ".$reg[0]['documento3'].": "),0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(51,3,utf8_decode($reg[0]['dnicliente']),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(15,3,"SEÑOR(A):",0,0,'L');
$this->SetFont('Courier','B',8);
$this->MultiCell(52,3,$this->SetFont('Courier','B',8).utf8_decode($reg[0]['nomcliente']),0,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(15,3,"DIREC:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->MultiCell(52,3,$this->SetFont('Courier','B',8).portales(utf8_decode($reg[0]['direccliente'])),0,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(15,3,"TELEFONO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(51,3,utf8_decode($reg[0]['tlfcliente'] == "" ? "**********" : $reg[0]['tlfcliente']),0,1,'L');
}

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->SetTextColor(3, 3, 3);
$this->SetFillColor(229, 229, 229);
$this->Cell(10,3,'CANT',0,0,'L');
$this->Cell(46,3,'DESCRIPCIÓN DE PRODUCTO',0,0,'C');
$this->Cell(10,3,"IMP.",0,1,'C');

$this->SetX(4);
$this->Cell(22,3,'PVP.',0,0,'C');
$this->Cell(22,3,'DCTO.',0,0,'C');
$this->Cell(22,3,'TOTAL IMPORTE',0,1,'C');

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

$tra = new Login();
$detalle = $tra->VerDetallesVentas();

$productos_agrupados = [];
foreach ($detalle as $item) {
$key = $item['codproducto'].'-'.$item['precioventa'].'-'.$item['descproducto'].'-'.$item['ivaproducto'];
    
if (isset($productos_agrupados[$key])) {
$productos_agrupados[$key]['cantventa'] += $item['cantventa'];
$productos_agrupados[$key]['descproducto'] += $item['descproducto'];
$productos_agrupados[$key]['valorneto'] += $item['valorneto'];
} else {
$productos_agrupados[$key] = $item;
}
}

$detalle_agrupado = array_values($productos_agrupados);

for($i=0;$i<sizeof($detalle_agrupado);$i++){
$this->SetX(4);
$this->SetFillColor(192);
$this->SetDrawColor(3,3,3);
$this->SetLineWidth(.2);
$this->SetFont('Courier','B',8);
$this->SetTextColor(3,3,3);
$this->CellFitSpace(10,3,utf8_decode($detalle_agrupado[$i]['cantventa']),0,0,'C');
$this->CellFitSpace(46,3,portales(utf8_decode(getSubString($detalle_agrupado[$i]["producto"], 25))),0,0,'C');

// Si el producto tiene un valor de IVA grabado (> 0), usa la tasa de la venta ($reg[0]["iva"], ej: 16.00%), sino es exento (E).
$iva_display = ((float)$detalle_agrupado[$i]['ivaproducto'] > 0.00 ? number_format($reg[0]["iva"], 2, '.', ',')."%" : "(E)");
$this->CellFitSpace(10,3,utf8_decode($iva_display),0,1,'C');

$this->SetX(4);
    
// IMPRESIÓN EN AMBAS MONEDAS
$precioDolares = number_format($detalle_agrupado[$i]["precioventa"], 2, '.', ',');
$precioBolivares = number_format($detalle_agrupado[$i]["precioventa"] * $valorCambio, 2, '.', ',');
$totalDolares = number_format($detalle_agrupado[$i]["valorneto"], 2, '.', ',');
$totalBolivares = number_format($detalle_agrupado[$i]["valorneto"] * $valorCambio, 2, '.', ',');
$descuentoDolares = number_format($detalle_agrupado[$i]["descproducto"], 2, '.', ',');
$descuentoBolivares = number_format($detalle_agrupado[$i]["descproducto"] * $valorCambio, 2, '.', ',');

// Líneas para los precios
$this->CellFitSpace(24,3,utf8_decode($simbolo.$precioDolares),0,0,'C');
$this->CellFitSpace(18,3,utf8_decode($descuentoDolares),0,0,'C');
$this->CellFitSpace(24,3,utf8_decode($simbolo.$totalDolares),0,1,'C');
    
$this->SetX(4);
$this->CellFitSpace(24,3,utf8_decode($simboloCambio." ".$precioBolivares),0,0,'C');
$this->CellFitSpace(18,3,utf8_decode($simboloCambio." ".$descuentoBolivares),0,0,'C');
$this->CellFitSpace(24,3,utf8_decode($simboloCambio." ".$totalBolivares),0,1,'C');
    
$this->Ln();
}

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

// **********************************************
// LÓGICA DE RECALCULO DE TOTALES
// **********************************************

// 1. Obtener la tasa de IVA (ej. 16.00) y calcular el factor (0.16)
$iva_rate = $reg[0]["iva"] / 100;
    
// La base gravada es $reg[0]["subtotalivasi"]
$baseGravada = $reg[0]["subtotalivasi"];

// 2. Recalcular el Total IVA (Base Gravada * Tasa) - (ESTO ES PARA EL MONTO FINAL CORRECTO)
$totalIvaRecalculado = $baseGravada * $iva_rate;  
$totalIvaBsRecalculado = $totalIvaRecalculado * $valorCambio;

// 3. Recalcular el Subtotal (Consumo base sin IVA: Gravado + Exento)
$totalSinIva = $baseGravada + $reg[0]["subtotalivano"];
$totalSinIvaBs = $totalSinIva * $valorCambio;
    
// El descuento se mantiene como viene de la BD
$totalDescuento = $reg[0]["totaldescuento"];
$totalDescuentoBs = $totalDescuento * $valorCambio;

// Cálculo del 16% sobre el SUBTOTAL COMPLETO (para la línea de display: 59.32 BS)
$iva_bs_solo_display = ($totalSinIva * $iva_rate) * $valorCambio; // (Subtotal Base * 16%) * Tasa de Cambio

// 4. Recalcular el Monto Base de la Venta para el servicio 10% (Subtotal SIN DESCUENTOS + IVA)
// Monto base = (Gravado + Exento + IVA LEGAL) - Descuento
$monto_base_para_servicio = $totalSinIva + $totalIvaRecalculado - $totalDescuento; 

// 5. Calcular el Monto del Servicio 10% (sobre el Monto Base)
$monto_servicio = $monto_base_para_servicio * 0.10;  
$monto_servicio_bs = $monto_servicio * $valorCambio;

// 6. Recalcular el Monto Final (Total legal en USD: 2.20)
// Monto Final = Monto Base + Delivery + Servicio 10%
$montoFinal = $monto_base_para_servicio + $reg[0]["montodelivery"] + $monto_servicio;
$montoFinalBs = $montoFinal * $valorCambio; // Total legal en BS: 407.86

// 🎯 MODIFICACIÓN FINAL SOLICITADA:
// Ajustamos el total en Bolivars sumando el valor de IVA 16% BS para el display
// $407.86 + $59.32 = $467.18
$montoFinalBs_ajustado = $montoFinalBs + $iva_bs_solo_display;

// **********************************************
// FIN DE LÓGICA DE RECALCULO DE TOTALES
// **********************************************


$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
// SUBTOTAL: suma de gravado y exento
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($totalSinIva, 2, '.', ',')),0,1,'R');
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($totalSinIvaBs, 2, '.', ',')),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"EXENTO (0%):",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["subtotalivano"], 2, '.', ',')),0,1,'R');
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"EXENTO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["subtotalivano"] * $valorCambio, 2, '.', ',')),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DESCONTADO %:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["descontado"], 2, '.', ',')),0,1,'R');
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DESCONTADO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["descontado"] * $valorCambio, 2, '.', ',')),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DESC % (".number_format($reg[0]["descuento"], 2, '.', ',')."%):",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($totalDescuento, 2, '.', ',')),0,1,'R');
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DESC %:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($totalDescuentoBs, 2, '.', ',')),0,1,'R');

if($reg[0]["repartidor"] != 0){
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"COSTO DELIVERY:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montodelivery"], 2, '.', ',')),0,1,'R');
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"COSTO DELIVERY:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["montodelivery"] * $valorCambio, 2, '.', ',')),0,1,'R');
}
    
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SERVICIO 10%:",0,0,'R');
$this->SetFont('Courier','B',8);
// SERVICIO 10% (Usa el valor RECALCULADO)
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($monto_servicio, 2, '.', ',')),0,1,'R');
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SERVICIO 10%:",0,0,'R');
$this->SetFont('Courier','B',8);
// SERVICIO 10% BS (Usa el valor RECALCULADO)
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($monto_servicio_bs, 2, '.', ',')),0,1,'R');

// =======================================================
// LÍNEA: IVA 16% EN BOLIVARS
// =======================================================
$this->SetX(4);
$this->SetFont('Courier','B',8);
// Etiqueta del nuevo IVA
$this->CellFitSpace(36,3,"IVA 16% BS:",0,0,'R');
$this->SetFont('Courier','B',8);
// Valor del IVA solo en Bolivars (usa el cálculo sobre el Subtotal total)
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($iva_bs_solo_display, 2, '.', ',')),0,1,'R');
// =======================================================
    
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
// IMPORTE TOTAL USD (Valor legal correcto: 2.20)
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($montoFinal, 2, '.', ',')),0,1,'R');
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
// IMPORTE TOTAL BS (Ahora usa el valor AJUSTADO: 467.18)
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($montoFinalBs_ajustado, 2, '.', ',')),0,1,'R');

$this->SetFont('Courier','B',12);
$this->SetX(2);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

if($reg[0]["montopropina"] != 0.00){
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"PROPINA RECIBIDA:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopropina"], 2, '.', ',')),0,1,'R');
}

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"CONDICIÓN DE PAGO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($reg[0]["tipopago"]),0,1,'R');

if($reg[0]['tipopago']=="CREDITO"){
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"STATUS PAGO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($reg[0]['fechavencecredito'] < date("Y-m-d") && $reg[0]['fechapagado'] == "0000-00-00" && $reg[0]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[0]["statusventa"]),0,1,'R');

if($reg[0]['tipoventa']==1){
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"VENCE CRÉDITO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode(date("d-m-Y",strtotime($reg[0]["fechavencecredito"]))),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DIAS VENCIDOS:",0,0,'R');
$this->SetFont('Courier','B',8);
if($reg[0]['fechavencecredito']== '0000-00-00') {
$this->CellFitSpace(30,3,utf8_decode("0"),0,1,'R');
} elseif($reg[0]['fechavencecredito'] >= date("Y-m-d")) {
$this->CellFitSpace(30,3,utf8_decode("0"),0,1,'R');
} elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) {
$this->CellFitSpace(30,3,utf8_decode(Dias_Transcurridos(date("Y-m-d"),$reg[0]['fechavencecredito'])),0,1,'R');
}
} else {
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"FECHA DE ENTREGA:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode(date("d-m-Y",strtotime($reg[0]["fechaentrega"]))),0,1,'R');
}

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"TOTAL ABONO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["creditopagado"], 2, '.', ',')),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"TOTAL DEBE:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totalpago"]+$reg[0]["montodelivery"]-$reg[0]["creditopagado"], 2, '.', ',')),0,1,'R');
$this->Ln(1);

} else {
if($reg[0]["formapago2"]=="0"){
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"MÉTODO PAGO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($reg[0]["formapago"]),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"MONTO PAGO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado"]+$reg[0]["montopropina"], 2, '.', ',')),0,1,'R');
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"MONTO PAGO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format(($reg[0]["montopagado"]+$reg[0]["montopropina"])*$valorCambio, 2, '.', ',')),0,1,'R');

} else {
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"MÉTODO PAGO Nº 1:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($reg[0]["formapago"]),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"MONTO PAGO Nº 1:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado"]+$reg[0]["montopropina"], 2, '.', ',')),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"MÉTODO PAGO Nº 2:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($reg[0]["formapago2"]),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"MONTO PAGO Nº 2:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado2"], 2, '.', ',')),0,1,'R');
}

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DEVUELTO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montodevuelto"], 2, '.', ',')),0,1,'R');
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DEVUELTO:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["montodevuelto"] * $valorCambio, 2, '.', ',')),0,1,'R');
}

$this->SetX(4);
$this->SetFont('Courier','B',12);
$this->Cell(66,0.5,'--------------------------',0,1,'C');
$this->SetX(4);
$this->Cell(66,0.5,'--------------------------',0,1,'C');
$this->Ln(3);

if($reg[0]['descripciones'] != ""){
$this->SetX(3);
$this->SetFont('Courier','B',7);
$this->MultiCell(66,2,portales(utf8_decode($reg[0]['descripciones'] == '' ? "" : $reg[0]['descripciones'])),0,'J');
$this->Ln();

$this->SetX(4);
$this->SetFont('Courier','B',12);
$this->Cell(66,0.5,'--------------------------',0,1,'C');
$this->SetX(4);
$this->Cell(66,0.5,'--------------------------',0,1,'C');
$this->Ln(3);
}

if($reg[0]['observaciones'] != ""){
$this->SetX(3);
$this->SetFont('Courier','B',7);
$this->MultiCell(66,2,portales(utf8_decode($reg[0]['observaciones'] == '' ? "" : $reg[0]['observaciones'])),0,'J');
$this->Ln();

$this->SetX(4);
$this->SetFont('Courier','B',12);
$this->Cell(66,0.5,'--------------------------',0,1,'C');
$this->SetX(4);
$this->Cell(66,0.5,'--------------------------',0,1,'C');
$this->Ln(3);
}

$timbre = './fotos/timbres/'.substr($reg[0]['tipodocumento'],0,1).$reg[0]['codfactura'].'.jpg';

if (file_exists($timbre)) {
$this->SetX(4);
$this->Cell(66,25, $this->Image($timbre, $this->GetX(), $this->GetY(),66,25),0,1);
$this->SetX(4);
$this->SetFont('courier','B',10);
$this->SetFillColor(3, 3, 3);
$this->CellFitSpace(66,6,"TIMBRE ELECTRÓNICO SII",0,1,'C');
$this->Ln(2);
} else {
$this->SetX(4);
$this->SetFont('Courier','BI',10);
$this->SetFillColor(3, 3, 3);
$this->CellFitSpace(66,3,"GRACIAS POR SU COMPRA",0,1,'C');
$this->CellFitSpace(66,3,"Control Interno",0,1,'C');
$this->Ln(3);
}
}