<?php

/**
 * Genera el Ticket de Precuenta compacto para una venta específica.
 *
 * NOTA: Esta versión accede a la DB directamente para evitar la agrupación 
 * de productos que realiza la función Login::DetallesPedido().
 *
 * @param int|string $codventa_o_factura ID de la venta o número de factura.
 */
function TicketPrecuenta($codventa_o_factura) 
{
    // Limpieza de Output Buffer como PRIMERA INSTRUCCIÓN EJECUTABLE de la función
    if (ob_get_contents()) ob_end_clean(); 
    
    // --- DATOS DE CONEXIÓN --- (Usando las credenciales proporcionadas)
    $host = 'localhost';
    $user = 'veliziasystem_hangang';
    $pass = 'Osito.1852570';
    $name = 'veliziasystem_corea';

    try {
        $db = new PDO("mysql:host=$host;dbname=$name", $user, $pass,
                        [PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"] );
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    } catch (PDOException $e) { die("Error de Conexión a DB: " . $e->getMessage()); }

    // 1. OBTENER CABECERA DE VENTA (Tabla: ventas)
    $stmt = $db->prepare("SELECT V.*, S.nomsala, M.nommesa, U.nombres, V.codfactura 
                          FROM ventas V 
                          LEFT JOIN mesas M ON V.codmesa = M.codmesa 
                          LEFT JOIN salas S ON M.codsala = S.codsala 
                          LEFT JOIN usuarios U ON V.codigo = U.codigo 
                          WHERE V.codventa = ? OR V.codfactura = ? LIMIT 1");
    
    $stmt->execute([$codventa_o_factura, $codventa_o_factura]);
    $reg = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$reg) { 
        $this->SetFont('Courier','B',10);
        $this->Cell(66, 5, utf8_decode("Error: Venta no encontrada (ID/Factura: ").$codventa_o_factura.")", 0, 1, 'C');
        return; 
    }

    // 2. TASA DE CAMBIO
    $res_tasa = $db->query("SELECT montocambio FROM tiposcambio ORDER BY codcambio DESC LIMIT 1")->fetch();
    $tasa = (float)($res_tasa['montocambio'] ?? 1);

    // --- ENCABEZADO Y DATOS PRINCIPALES ---
    $this->SetFont('Courier','B',10);
    $this->Cell(66,4,"HANGANG", 0, 1, 'C');
    // ... (resto del encabezado omitido por espacio, asumiendo que es el mismo) ...
    $this->SetFont('Courier','B',8);
    $this->Cell(66,3,"J-506889668",0,1,'C');
    $this->Cell(66,3,"INVERSIONES HANMAUM C.A",0,1,'C');
    $this->MultiCell(66,3,utf8_decode("AV VENEZUELA ENTRE AV SOJO Y CALLE MOHEDANO LOCAL TORRE EMPRESARIAL K NRO 2 URB EL ROSAL CARACAS (CHACAO) MIRANDA ZONA POSTAL 1060"),0,'C');
    
    $this->Ln(2);
    $this->Cell(66,3,'--------------------------',0,1,'C');

    // NÚMERO DE TICKET 
    $this->SetFont('Courier','B',10);
    $ticket_num = $reg['codfactura'] ?? $reg['codventa'];
    $this->Cell(66,5,utf8_decode("TICKET Nº: ").$ticket_num,0,1,'L');

    $this->SetFont('Courier','B',8);
    $this->Cell(66,3,"SALA: ".utf8_decode($reg['nomsala'] ?? 'N/A'),0,1,'L');
    $this->Cell(66,3,utf8_decode("Nº MESA: ".($reg['nommesa'] ?? 'N/A')),0,1,'L');
    $this->Cell(66,3,"MESERO: ".utf8_decode($reg['nombres'] ?? 'N/A'),0,1,'L');
    $this->Cell(66,3,utf8_decode("FECHA EMISION: ").date("d-m-Y H:i:s",strtotime($reg['fechaventa'])),0,1,'L');
    
    $this->Cell(66,3,'--------------------------',0,1,'C');

    // --- ENCABEZADO DE PRODUCTOS (Compacto) ---
    $this->SetX(4);
    $this->SetFont('Courier','B',9);
    $this->Cell(10, 3, "cant", 0, 0, 'L');
    $this->Cell(56, 3, utf8_decode("producto Bs."), 0, 1, 'L'); 
    
    $this->Cell(66,3,'--------------------------',0,1,'C');
    
    // 3. OBTENER DETALLE DE PRODUCTOS SIN AGRUPAR (Tabla: detalleventas)
    $stmt_det = $db->prepare("SELECT 
        coddetalleventa, -- Usamos el ID de la línea para asegurar que no se agrupe.
        producto, 
        cantventa, 
        valorneto 
        FROM detalleventas 
        WHERE codventa = ?"); // Clave: NO usamos GROUP BY
        
    $stmt_det->execute([$reg['codventa']]);
    $detalles = $stmt_det->fetchAll(PDO::FETCH_ASSOC);

    // Bucle para imprimir CADA LINEA DE VENTA individualmente
    foreach ($detalles as $item) {
        $cantidad = (float)$item['cantventa'];
        $nombre_raw = str_replace("<br>", " ", $item['producto']);
        $partes = explode('|', $nombre_raw);
        $temp_name = (count($partes) > 1) ? $partes[1] : $partes[0];
        $nombre_limpio = trim(preg_replace('/[^A-Za-z0-9\s\/\.\-]/', '', $temp_name));
        
        // Calculamos el precio total de la línea (Cant * Precio Unitario)
        $precio_total_linea_usd = (float)$item['valorneto']; // valorneto en detalleventas es el total de la línea (valorneto * cantventa)
        
        // **IMPORTANTE**: La tabla `detalleventas` tiene `valorneto` como el precio total de la línea,
        // no el precio unitario, según la estructura que me mostró anteriormente.
        // Si el precio unitario es lo que necesita, tendrá que dividirlo,
        // pero para la precuenta usaremos el total de la línea, que es lo más común.
        
        $precio_total_linea_bs = $precio_total_linea_usd * $tasa;
        
        $this->SetFont('Courier','',8);
        
        // Columna 1: Cantidad
        $cantidad_formato = number_format($cantidad,0); 
        $this->Cell(10, 4, $cantidad_formato, 0, 0, 'L'); 

        // Columna 2: Producto + Precio 
        $texto_bs = "Bs.".number_format($precio_total_linea_bs, 2, ',', '.');
        $linea_completa = utf8_decode($nombre_limpio) . ' ' . $texto_bs;
        
        $this->CellFitSpace(56, 4, $linea_completa, 0, 1, 'L'); 
    }

    $this->Cell(66,3,'--------------------------',0,1,'C');

    // 4. TOTALES (Usando los valores de la tabla ventas para exactitud)
    $subtotal_usd = (float)($reg['subtotalivasi'] + $reg['subtotalivano']);
    $iva_usd      = (float)$reg['iva'] ?? 0;
    $propina_usd  = (float)$reg['montopropina'] ?? 0;
    $total_usd    = (float)$reg['totalpago'];

    // ... (Resto de la impresión de totales mantenida igual) ...
    $this->SetFont('Courier','B',8);
    
    // SUBTOTAL (USD)
    $this->Cell(36,3,"SUBTOTAL:",0,0,'L');
    $this->Cell(30,3,number_format($subtotal_usd, 2, '.', ''),0,1,'R');

    // SUBTOTAL BS
    $this->Cell(36,3,"SUBTOTAL BS:",0,0,'L');
    $this->Cell(30,3,number_format($subtotal_usd * $tasa, 2, ',', '.'),0,1,'R');
    
    // IVA
    $this->Cell(36,3,"IVA (".number_format($iva_usd > 0 ? 16 : 0, 0)."%):",0,0,'L');
    $this->Cell(30,3,number_format($iva_usd, 2, '.', ''),0,1,'R');

    // PROPINA (Si aplica)
    if($propina_usd > 0){
        $this->Cell(36,3,"PROPINA:",0,0,'L');
        $this->Cell(30,3,number_format($propina_usd, 2, '.', ''),0,1,'R');
    }

    $this->Ln(1);
    $this->SetFont('Courier','B',9);
    
    // TOTAL A PAGAR $
    $this->Cell(36,4,"TOTAL A PAGAR $:",0,0,'L');
    $this->Cell(30,4,"$".number_format($total_usd, 2, '.', ''),0,1,'R');
    
    // TOTAL A PAGAR BS
    $this->Cell(36,4,"TOTAL A PAGAR BS:",0,0,'L');
    $this->Cell(30,4,number_format($total_usd * $tasa, 2, ',', '.'),0,1,'R');

    // 5. DETALLE DE PAGO
    $this->Ln(2);
    $this->SetFont('Courier','B',8);
    $this->Cell(66,4,utf8_decode("DETALLE DE PAGO:"),0,1,'L');
    
    // ... (Impresión de pagos) ...
    if(!empty($reg['formapago'])){
        $m1_usd = (float)$reg['montopagado'];
        $this->Cell(30,3,utf8_decode($reg['formapago']).":",0,0,'L');
        $this->Cell(36,3,number_format($m1_usd, 2)." / Bs.".number_format($m1_usd * $tasa, 2, ',', '.'),0,1,'R');
    }
    
    if(!empty($reg['formapago2']) && (float)$reg['montopagado2'] > 0){
        $m2_usd = (float)$reg['montopagado2'];
        $this->Cell(30,3,utf8_decode($reg['formapago2']).":",0,0,'L');
        $this->Cell(36,3,number_format($m2_usd, 2)." / Bs.".number_format($m2_usd * $tasa, 2, ',', '.'),0,1,'R');
    }

    $this->Ln(2);
    $this->Cell(66,4,"GRACIAS POR PREFERIRNOS",0,1,'C');
    $this->SetFont('Courier','BI',6);
    $this->Cell(66,3,"Control interno - no fiscal",0,1,'C');
}
?>