<?php
// ========== CLASE DE CONEXIÓN SIMPLIFICADA (DEBES AJUSTAR LOS DATOS) ==========

// Importante: Reemplaza estos datos con los reales de tu classconexion.php
define('DB_HOST', 'localhost');
define('DB_USERNAME', 'veliziasystem_hangang');
define('DB_PASSWORD', 'Osito.1852570');
define('DB_NAME', 'veliziasystem_corea');

class Db {
    protected $dbh;

    public function __construct(){
        try{
            date_default_timezone_set("America/Caracas");
            $conn = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME, DB_USERNAME, DB_PASSWORD,
                array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"));
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->dbh = $conn;
        }catch(PDOException $e){
            die("Error de Conexión: " . $e->getMessage());
        }
    }
    
    // Método para ejecutar consultas y devolver un array de resultados
    public function DBConsulta($sql) {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

// ========== CLASE LOGIN (ASUMIENDO QUE EXISTE Y HEREDA LA CONEXIÓN) ==========
// Si tu clase Login no hereda, tendrás que instanciar Db dentro de Login.
// Aquí asumimos que Login tiene acceso a DBConsulta.
class Login extends Db {
    public function ExpiraSession() {
        // Lógica de expiración de sesión
        return true; 
    }
    // Otros métodos de Login...
}

// INICIO DE SESIÓN Y VERIFICACIÓN DE ACCESO
session_start();
// Configuración de variables de sesión para el ejemplo (DEBES REMOVER ESTAS LÍNEAS EN PRODUCCIÓN)
if (!isset($_SESSION['acceso'])) {
    $_SESSION['acceso'] = 'administradorG';
}

if(isset($_SESSION['acceso'])) { 
    if ($_SESSION["acceso"]=="administradorG" || $_SESSION["acceso"]=="administradorS" || $_SESSION["acceso"]=="secretaria" || $_SESSION["acceso"]=="cajero") {

$tra = new Login();
$ses = $tra->ExpiraSession();          

// === LÓGICA DEL REPORTE PHP ===

$fecha_inicio = isset($_POST['fecha_inicio']) ? $_POST['fecha_inicio'] : date('Y-m-01');
$fecha_fin = isset($_POST['fecha_fin']) ? $_POST['fecha_fin'] : date('Y-m-d');

$datos_detalle = [];
$datos_resumen = [];
$total_general = 0;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Aseguramos que el rango cubra todo el día final
    $fecha_inicio_sql = $fecha_inicio . ' 00:00:00';
    $fecha_fin_sql = $fecha_fin . ' 23:59:59';
    
    // Escapar variables para seguridad (aunque PDO lo hace, aquí usamos interpolación directa)
    $f_ini = $fecha_inicio_sql;
    $f_fin = $fecha_fin_sql;

    // 1. CONSULTA DETALLE
    $sql_detalle = "
        SELECT 
            V.idventa, DATE(V.fechaventa) AS fecha, V.montopropina AS monto, V.formapropina AS metodo_pago, M.nombres AS nombre_mesero 
        FROM ventas V
        LEFT JOIN usuarios M ON V.mesero = M.codigo
        WHERE V.montopropina > 0 
        AND V.fechaventa BETWEEN '$f_ini' AND '$f_fin'
        ORDER BY M.nombres, V.fechaventa
    ";
    $datos_detalle = $tra->DBConsulta($sql_detalle);

    // 2. CONSULTA RESUMEN POR MESERO
    $sql_resumen = "
        SELECT 
            M.nombres AS nombre_mesero, SUM(V.montopropina) AS total_propina_mesero
        FROM ventas V
        LEFT JOIN usuarios M ON V.mesero = M.codigo
        WHERE V.montopropina > 0
        AND V.fechaventa BETWEEN '$f_ini' AND '$f_fin'
        GROUP BY M.nombres
        ORDER BY total_propina_mesero DESC
    ";
    $datos_resumen = $tra->DBConsulta($sql_resumen);

    // 3. CONSULTA TOTAL GENERAL
    $sql_total = "
        SELECT 
            SUM(montopropina) AS gran_total
        FROM ventas
        WHERE montopropina > 0
        AND fechaventa BETWEEN '$f_ini' AND '$f_fin'
    ";
    $resultado_total = $tra->DBConsulta($sql_total);
    $total_general = $resultado_total[0]['gran_total'] ?? 0;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte de Propinas</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .container { max-width: 1200px; margin: auto; }
        .filtro-box { margin-bottom: 20px; padding: 15px; border: 1px solid #ccc; border-radius: 5px; background: #f9f9f9; display: flex; align-items: center; }
        .filtro-box label, .filtro-box input, .filtro-box button { margin-right: 15px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .total-box { margin-top: 20px; padding: 15px; border: 2px solid #333; font-weight: bold; }
        .resumen-table-container { float: right; width: 45%; margin-top: 20px; }
        .total-box-container { float: left; width: 45%; margin-top: 20px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Reporte de Propinas Recibidas</h1>
        
        <div class="filtro-box">
            <form method="POST" style="display: flex; align-items: center;">
                <label for="fecha_inicio">Desde:</label>
                <input type="date" id="fecha_inicio" name="fecha_inicio" value="<?php echo $fecha_inicio; ?>" required>

                <label for="fecha_fin">Hasta:</label>
                <input type="date" id="fecha_fin" name="fecha_fin" value="<?php echo $fecha_fin; ?>" required>

                <button type="submit" name="btn-filtrar">Filtrar Reporte</button>
            </form>
        </div>

        <?php if ($_SERVER["REQUEST_METHOD"] == "POST") { ?>
            
            <div style="overflow: hidden; margin-bottom: 30px;">
                
                <div class="total-box-container">
                    <div class="total-box" style="border-color: green;">
                        <h3>TOTAL GENERAL DE PROPINAS</h3>
                        <p style="font-size: 2em; color: green;">$ <?php echo number_format($total_general, 2); ?></p>
                    </div>
                </div>

                <div class="resumen-table-container">
                    <h3>Resumen por Mesero</h3>
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Mesero</th>
                                <th>Total Propina</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (is_array($datos_resumen) && count($datos_resumen) > 0) {
                                foreach ($datos_resumen as $resumen) { ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($resumen['nombre_mesero']); ?></td>
                                    <td style="text-align: right;">$ <?php echo number_format($resumen['total_propina_mesero'], 2); ?></td>
                                </tr>
                            <?php } } else { ?>
                                <tr><td colspan="2">No hay propinas para el resumen.</td></tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <h2>Detalle de Propinas (<?php echo $fecha_inicio; ?> al <?php echo $fecha_fin; ?>)</h2>
            <table>
                <thead>
                    <tr>
                        <th>ID Venta</th>
                        <th>Fecha</th>
                        <th>Mesero</th>
                        <th>Monto Propina</th>
                        <th>Método de Pago</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (is_array($datos_detalle) && count($datos_detalle) > 0) {
                        foreach ($datos_detalle as $detalle) { ?>
                        <tr>
                            <td><?php echo htmlspecialchars($detalle['idventa']); ?></td>
                            <td><?php echo htmlspecialchars($detalle['fecha']); ?></td>
                            <td><?php echo htmlspecialchars($detalle['nombre_mesero']); ?></td>
                            <td style="text-align: right;">$ <?php echo number_format($detalle['monto'], 2); ?></td>
                            <td><?php echo htmlspecialchars($detalle['metodo_pago']); ?></td>
                        </tr>
                    <?php } } else { ?>
                        <tr><td colspan="5">No se encontraron propinas en el rango de fechas seleccionado.</td></tr>
                    <?php } ?>
                </tbody>
            </table>
            
        <?php } else { ?>
            <p>Selecciona un rango de fechas y haz clic en "Filtrar Reporte" para ver la información.</p>
        <?php } ?>

    </div>
</body>
</html>

<?php 
// El script original termina con este cierre
} else { ?>    
        <script type='text/javascript' language='javascript'>
        alert('NO TIENES PERMISO PARA ACCEDER A ESTA PAGINA.\nCONSULTA CON...');
        window.location='logout.php';
        </script>
<?php } } else { 
    // El script original termina con este cierre
    header("Location: ../index.php"); 
} 
?>