<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// 1. Cargamos la conexión y las consultas (Donde reside la clase Login)
require_once("class/class.consultas.php"); 

// 2. Cargamos la estructura del PDF (Donde pegaste la función TicketCompleto)
require_once("fpdf/pdf.php"); 

if (isset($_GET['codventa'])) {
    $codventa = $_GET['codventa'];

    /* OJO AQUÍ: 
       Si en fpdf/pdf.php la clase empieza como "class PDF extends FPDF", 
       aquí debes poner: new PDF(...)
       Si la clase se llama "class Reporte extends FPDF", pon: new Reporte(...)
    */
    
    // Suponiendo que la clase en fpdf/pdf.php se llama 'PDF'
    $pdf = new PDF('P','mm',array(76, 200)); 
    
    $pdf->SetMargins(2, 2, 2);
    $pdf->SetAutoPageBreak(true, 2);
    $pdf->AddPage();
    
    // Ejecutamos la función que tiene el formato de Hangang
    $pdf->TicketCompleto($codventa);

    // Salida al navegador
    $pdf->Output("I", "Ticket_".$codventa.".pdf");
} else {
    echo "Falta el código de venta.";
}